  option autorun on
  Option default Integer
  Option explicit
  CLS
  
  timer = 0
  
  dim integer h, l, r, maxtr = 40 'set temperature at top of screen
  dim float Temperature, OldTemp
  dim FLOAT humidity, Oldhumidity
  dim integer Tickrate = (24*60*60*1000/320) '24 Hours to fill screen. Hrs, Mins, Secs, mSecs, Pixels  cls
   
  for l = 1 to 240 'Create horizontal lines lines
    
    if l mod 40 = 0 then
      line 1, l, 320, l, 1 , RGB(0,0,255)
    elseif l mod 8 = 0 then
      line 1, l, 320, l, 1 , RGB(0,128,128)
    endif
    
  next l
  
  for l = 1 to 320 'Create vertical lines
    
    if l mod 40 = 0 then line l, 1, l, 240, 1 , RGB(0,0,255)
    
  Next l
  
  h = 1
  
  HUMID 16, Temperature, humidity
  'PRINT "The temperature is" Temperature CHR$(186)" and the humidity is" humidity "%"
  text 5, 2, "T:"+str$(Temperature,3,1),lt, 1, 2, rgb(White), rgb(Black)
  text 165, 2, "H:"+str$(humidity,3,1)+"%",lt, 1, 2, rgb(green), rgb(Black)
  OldTemp = Temperature
  Oldhumidity = humidity
  Pause 2000
  
  text 1, 40, str$(maxtr - 5), lm, 1, 1, RGB(white) 'Create scale at beginning of lines
  text 1, 80, str$(maxtr - 10), lm, 1, 1, RGB(white) 'Bottom of screen = 10 degrees
  text 1, 120, str$(maxtr - 15), lm, 1, 1, RGB(white) 'Top of screen = 40 degrees
  text 1, 160, str$(maxtr - 20), lm, 1, 1, RGB(white)
  text 1, 200, str$(maxtr - 25), lm, 1, 1, RGB(white)
  
  text 320, 40, "100", rm, 1, 1, RGB(green) 'Create scale at end of lines
  text 320, 80, "80", rm, 1, 1, RGB(green) 'Bottom of screen = 0%
  text 320, 120, "60", rm, 1, 1, RGB(green) 'Top of screen = 100#
  text 320, 160, "40", rm, 1, 1, RGB(green)
  text 320, 200, "20", rm, 1, 1, RGB(green)
  
  settick Tickrate, Readings'set time between chart readings
  
  do  'Update values at top of screen to show current values
    
    HUMID 16, Temperature, humidity
    text 5, 2, "T:"+str$(Temperature,3,1),lt, 1, 2, rgb(White), rgb(Black)
    text 165, 2, "H:"+str$(humidity,3,1)+"%",lt, 1, 2, rgb(green), rgb(Black)
    
    circle 313 , 7, 4, 0,,, rgb(white)  'indicates program is running
    pause 1000
    circle 313 , 7, 4, 0,,, rgb(black)
    Pause 1000
    
    
  loop
  
sub Readings
  
  if h > 320 then h=1 ' Restart at left of screen and refresh scale if necessary.
  
  for  r = 1 to 240 'Refresh horizontal lines and clear previos reading display
    
    if r mod 40 = 0 then
      pixel h, r, RGB(0,0,255)
    elseif r mod 8 = 0 then
      pixel h, r, RGB(0,128,128)
    else
      pixel h, r, RGB(0,0,0)
    endif
    
  next r
  
  
  if h mod 40 = 0 then line h, 1, h, 240, 1 , RGB(0,0,255) 'Refresh vertical lines
  
  if h > 1 then
    line h-1, ((maxtr-OldTemp)*8), h, ((maxtr-temperature)*8), 1, rgb(White) 'draws line from previous point to new poin
    line h-1, (240 - (Oldhumidity*2)), h, (240 - (humidity*2)), 1, rgb(green)
  endif
  
  line h+1, 232, h+1, 240, 1, rgb(cyan) 'Insert marker to show where current reading is (reading is one pixel behind marker)
  ' Previous marker is cleared by line refreshing process.
  
  OldTemp = Temperature
  Oldhumidity = humidity
  
  h = h + 1 'next h
  
  'Refresh Scale
  text 1, 40, str$(maxtr - 5), lm, 1, 1, RGB(white) 'Create scale at beginning of lines
  text 1, 80, str$(maxtr - 10), lm, 1, 1, RGB(white)
  text 1, 120, str$(maxtr - 15), lm, 1, 1, RGB(white)
  text 1, 160, str$(maxtr - 20), lm, 1, 1, RGB(white)
  text 1, 200, str$(maxtr - 25), lm, 1, 1, RGB(white)
  
  text 320, 40, "100", rm, 1, 1, RGB(green) 'Create scale at end of lines
  text 320, 80, "80", rm, 1, 1, RGB(green)
  text 320, 120, "60", rm, 1, 1, RGB(green)
  text 320, 160, "40", rm, 1, 1, RGB(green)
  text 320, 200, "20", rm, 1, 1, RGB(green)
  
end sub
  
CSub HUMID integer, float, float
  0000002B 27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008
  27BD0008 27BDFFE0 AFBF001C 00002021 3C059D00 24A50040 27A60010 0411FFF1
  00000000 8FA30010 3C029D00 8C4200BC 3C049D00 24840414 0040F809 00832021
  8FBF001C 03E00008 27BD0020 00041080 000419C0 00621823 00642021 000418C0
  3C029D00 8C420000 3C047735 34849400 8C420000 0082001B 004001F4 00002012
  0064001B 008001F4 03E00008 00001012
  27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C
  AFB20028 AFB10024 AFB00020 00808821 00A0A821 3C029D00 8C420000 8C430000
  3C020098 34429680 0062102B 10400003 00C0B021 0411FFC7 00000000 3C109D00
  8E02001C 8E240000 0040F809 24050006 8E020010 8E240000 24050009 0040F809
  00003021 8E02001C 8E240000 0040F809 2405000E 8E02001C 8E240000 0040F809
  24050005 8E020004 0040F809 240403E8 8E02001C 8E240000 0040F809 24050006
  8E020080 240403E8 0040F809 00002821 AEC20000 AEA20000 0411FFB8 24040190
  00409821 0000A021 40944800 00008021 10000005 3C129D00 40104800 0270102B
  1440008E 8FBF0044 8E420020 0040F809 8E240000 1440FFF8 00000000 10000007
  3C129D00 40104800 0270102B 50400004 8E420020 10000081 8FBF0044 8E420020
  0040F809 8E240000 1040FFF6 00000000 10000007 3C129D00 40104800 0270102B
  50400004 8E420020 10000074 8FBF0044 8E420020 0040F809 8E240000 1440FFF6
  00001021 00001821 AFA20010 AFA30014 0000B821 10000005 3C129D00 40104800
  0270102B 14400065 8FBF0044 8E420020 0040F809 8E240000 1040FFF8 00000000
  40944800 10000006 8E420020 40104800 0270102B 14400059 8FBF0044 8E420020
  0040F809 8E240000 1440FFF8 8FA30010 000317C2 8FA50014 0005F040 005EF025
  00031040 AFA20018 0411FF6C 24040032 0050102B 8FA30018 00431025 AFA20010
  26F70001 24050028 16E5FFE0 AFBE0014 001E1600 8FA50010 00052202 00442025
  001E1200 00058E02 00518825 7CA33C00 308200FF 00621821 322200FF 00621821
  93A50014 30A200FF 00621021 8FA30010 00431026 304200FF 1440002F 001EA603
  3C109D00 8E130064 8E020080 30847FFF 0040F809 00002821 00409021 8E020080
  2404000A 0040F809 00002821 02402021 0260F809 00402821 00408021 AEA20000
  3C020080 8FA50010 00451024 5040000C 3C109D00 3C029D00 8C520058 8C420080
  2404FFFF 0040F809 2405FFFF 02002021 0240F809 00402821 AEA20000 3C109D00
  8E120064 8E020080 02202021 0040F809 02802821 00408821 8E020080 2404000A
  0040F809 00002821 02202021 0240F809 00402821 AEC20000 8FBF0044 8FBE0040
  8FB7003C 8FB60038 8FB50034 8FB40030 8FB3002C 8FB20028 8FB10024 8FB00020
  03E00008 27BD0048 20555043 65657073 6F742064 6F6C206F 000A0D77
End CSub
  
End
  
